/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.service;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.launcher.runtime.client.ServerPinger;

public class PingService {
    private final Map<String, CompletableFuture<PingServerReport>> reports = new ConcurrentHashMap<String, CompletableFuture<PingServerReport>>();

    public CompletableFuture<PingServerReport> getPingReport(String serverName) {
        CompletableFuture report = this.reports.computeIfAbsent(serverName, k -> new CompletableFuture());
        return report;
    }

    public void addReports(Map<String, PingServerReport> map) {
        map.forEach((k, v) -> {
            CompletableFuture<PingServerReport> report = this.getPingReport((String)k);
            report.complete((PingServerReport)v);
        });
    }

    public void addReport(String name, ServerPinger.Result result) {
        CompletableFuture<PingServerReport> report = this.getPingReport(name);
        PingServerReport value = new PingServerReport(name, result.maxPlayers, result.onlinePlayers);
        report.complete(value);
    }

    public void clear() {
        this.reports.forEach((k, v) -> {
            if (!v.isDone()) {
                v.completeExceptionally(new InterruptedException());
            }
        });
        this.reports.clear();
    }

    public static class PingServerReport {
        public final String name;
        public final int maxPlayers;
        public final int playersOnline;

        public PingServerReport(String name, int maxPlayers, int playersOnline) {
            this.name = name;
            this.maxPlayers = maxPlayers;
            this.playersOnline = playersOnline;
        }
    }
}

